<?php
header('Content-Type: application/json'); require_once __DIR__ . '/../utils/Config.php'; require_once SRC_PATH . '/classes/Database.php'; require_once SRC_PATH . '/controllers/MissionController.php'; require_once SRC_PATH . '/classes/LanguageController.php'; session_start(); $languageController = LanguageController::getInstance(); $endpoint = $_GET['action'] ?? $_POST['action'] ?? ''; function checkActiveMission() { global $languageController; if (!isset($_SESSION['active_mission_id'])) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.no_active_mission') ]); exit; } } function validateMission($missionId, $requiredStatus = null) { global $languageController; $missionController = new MissionController(); $mission = $missionController->getMission($missionId); if (!$mission) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_found') ]); exit; } if ($requiredStatus && $mission->getStatus() != $requiredStatus) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_in_progress') ]); exit; } return $mission; } if ($endpoint === 'filesystem') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $directory = isset($_POST['directory']) ? $_POST['directory'] : '/'; if (!$missionId || !$targetIp) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); $db = Database::getInstance(); $sshCheck = $db->query( "SELECT ssh_required, ssh_username, ssh_password FROM mission_filesystem
         WHERE mission_id = ? AND target_ip = ? AND path = '/' AND ssh_required = 1 LIMIT 1", [$missionId, $targetIp] )->fetch(); if ($sshCheck) { $sessionKey = "ssh_authenticated_{$missionId}_{$targetIp}"; if (!isset($_SESSION[$sessionKey]) || $_SESSION[$sessionKey] !== true) { echo json_encode([ 'success' => false, 'ssh_required' => true, 'message' => $languageController->translate('api.ssh_authentication_required') ]); exit; } } $files = $missionController->getFilesystem($missionId, $targetIp, $directory); echo json_encode([ 'success' => true, 'files' => $files ]); } elseif ($endpoint === 'ssh_authenticate') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $username = isset($_POST['username']) ? $_POST['username'] : ''; $password = isset($_POST['password']) ? $_POST['password'] : ''; if (!$missionId || !$targetIp || !$username || !$password) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_credentials') ]); exit; } $mission = validateMission($missionId); $db = Database::getInstance(); $sshInfo = $db->query( "SELECT ssh_username, ssh_password FROM mission_filesystem
         WHERE mission_id = ? AND target_ip = ? AND path = '/' AND ssh_required = 1 LIMIT 1", [$missionId, $targetIp] )->fetch(); if (!$sshInfo) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.ssh_not_required') ]); exit; } if ($username === $sshInfo['ssh_username'] && $password === $sshInfo['ssh_password']) { $sessionKey = "ssh_authenticated_{$missionId}_{$targetIp}"; $_SESSION[$sessionKey] = true; echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.ssh_authentication_successful') ]); } else { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.ssh_invalid_credentials') ]); } exit; } elseif ($endpoint === 'check_ssh_required') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; if (!$missionId || !$targetIp) { echo json_encode([ 'success' => false, 'ssh_required' => false ]); exit; } $db = Database::getInstance(); $sshCheck = $db->query( "SELECT ssh_required, ssh_username, ssh_password FROM mission_filesystem
         WHERE mission_id = ? AND target_ip = ? AND path = '/' AND ssh_required = 1 LIMIT 1", [$missionId, $targetIp] )->fetch(); if ($sshCheck) { $sessionKey = "ssh_authenticated_{$missionId}_{$targetIp}"; if (!isset($_SESSION[$sessionKey]) || $_SESSION[$sessionKey] !== true) { echo json_encode([ 'success' => true, 'ssh_required' => true, 'target_ip' => $targetIp ]); exit; } } echo json_encode([ 'success' => true, 'ssh_required' => false ]); exit; } elseif ($endpoint === 'clear_ssh_session') { $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : ($_SESSION['active_mission_id'] ?? null); $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; if ($missionId && $targetIp) { $sessionKey = "ssh_authenticated_{$missionId}_{$targetIp}"; unset($_SESSION[$sessionKey]); } echo json_encode([ 'success' => true ]); exit; } elseif ($endpoint === 'log_command') { $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : ($_SESSION['active_mission_id'] ?? null); $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $command = isset($_POST['command']) ? $_POST['command'] : ''; if (!$missionId || !$targetIp || !$command) { echo json_encode([ 'success' => true, 'trace_level' => 0, 'timer_started' => false, 'message' => 'Command not logged - no active mission' ]); exit; } $missionController = new MissionController(); $mission = $missionController->getMission($missionId); if (!$mission) { echo json_encode([ 'success' => true, 'trace_level' => 0, 'timer_started' => false, 'message' => 'Command not logged - mission not found' ]); exit; } if ($mission->getStatus() == Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => true, 'trace_level' => 0, 'timer_started' => false, 'message' => $languageController->translate('api.command_not_logged') ]); exit; } if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_in_progress') ]); exit; } $traceImpact = 1; $safeCommands = ['help']; $advancedCommands = [ 'scan' => 5, 'bypass' => 8, 'brute' => 10, 'inject' => 12, 'proxy' => 6, 'decrypt' => 7 ]; $baseCommand = explode(' ', $command)[0]; if (in_array($baseCommand, $safeCommands)) { $traceImpact = 0; } elseif (array_key_exists($baseCommand, $advancedCommands)) { $traceImpact = $advancedCommands[$baseCommand]; } if ($missionId == 1) { $lowerCommand = strtolower(trim($command)); if (strpos($lowerCommand, 'help') === 0) { $_SESSION['mission_help_used'] = true; } elseif (strpos($lowerCommand, 'ls') === 0) { $_SESSION['mission_ls_used'] = true; } elseif (strpos($lowerCommand, 'cd home') !== false) { $_SESSION['mission_cd_home_used'] = true; } elseif (strpos($lowerCommand, 'cd ..') !== false) { $_SESSION['mission_cd_back_used'] = true; } elseif (strpos($lowerCommand, 'cd var/db') !== false || strpos($lowerCommand, 'cd /var/db') !== false) { $_SESSION['mission_cd_var_step'] = true; $_SESSION['mission_cd_var_db_used'] = true; } elseif (strpos($lowerCommand, 'cd var') !== false) { if (!isset($_SESSION['mission_cd_var_step'])) { $_SESSION['mission_cd_var_step'] = true; } } elseif (strpos($lowerCommand, 'cd db') !== false) { if (isset($_SESSION['mission_cd_var_step']) && $_SESSION['mission_cd_var_step'] === true) { $_SESSION['mission_cd_var_db_used'] = true; } } elseif (strpos($lowerCommand, 'cat customers.db') !== false || strpos($lowerCommand, 'cat /var/db/customers.db') !== false) { $_SESSION['mission_cat_customers_used'] = true; } elseif (strpos($lowerCommand, 'cp customers.db') !== false || strpos($lowerCommand, 'cp /var/db/customers.db') !== false) { $_SESSION['mission_cp_customers_used'] = true; } } $missionController = new MissionController(); $result = $missionController->logCommand($missionId, $targetIp, $command, $traceImpact); echo json_encode($result); } elseif ($endpoint === 'notes') { $task = isset($_POST['task']) ? $_POST['task'] : (isset($_GET['task']) ? $_GET['task'] : 'list'); $db = Database::getInstance(); if ($task === 'list') { $rows = $db->query("SELECT id, title, content, created_at, updated_at FROM player_notes ORDER BY updated_at DESC")->fetchAll(); echo json_encode([ 'success' => true, 'notes' => $rows ]); exit; } elseif ($task === 'save') { $id = isset($_POST['id']) ? (int)$_POST['id'] : 0; $title = isset($_POST['title']) ? $_POST['title'] : ''; $content = isset($_POST['content']) ? $_POST['content'] : ''; if ($id && $id > 0) { $db->query("UPDATE player_notes SET title = ?, content = ?, updated_at = CURRENT_TIMESTAMP WHERE id = ?", [$title, $content, $id]); echo json_encode(['success' => true, 'id' => $id]); exit; } else { $db->query("INSERT INTO player_notes (title, content) VALUES (?, ?)", [$title, $content]); $newId = $db->lastInsertId(); echo json_encode(['success' => true, 'id' => $newId]); exit; } } elseif ($task === 'delete') { $id = isset($_POST['id']) ? (int)$_POST['id'] : 0; if ($id && $id > 0) { $db->query("DELETE FROM player_notes WHERE id = ?", [$id]); echo json_encode(['success' => true]); exit; } echo json_encode(['success' => false, 'message' => $languageController->translate('api.missing_required_parameters')]); exit; } echo json_encode(['success' => false, 'message' => $languageController->translate('api.unknown_action')]); exit; } elseif ($endpoint === 'get_status') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $mission = validateMission($missionId); echo json_encode([ 'success' => true, 'status' => $mission->getStatus(), 'message' => $languageController->translate('api.mission_status_retrieved') ]); } elseif ($endpoint === 'fail') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $mission = validateMission($missionId, Mission::STATUS_IN_PROGRESS); $missionController = new MissionController(); $result = $missionController->failMission($missionId); unset($_SESSION['active_mission_id']); echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.mission_failed') ]); } elseif ($endpoint === 'update_directory') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $directory = isset($_POST['directory']) ? $_POST['directory'] : '/'; if (!$missionId) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); $progress = $missionController->getMissionProgress($missionId); $currentIp = $progress['current_ip']; $db = Database::getInstance(); $dirCheck = $db->query( "SELECT path FROM mission_filesystem
         WHERE mission_id = ? AND target_ip = ? AND LOWER(path) = LOWER(?) AND is_directory = 1", [$missionId, $currentIp, $directory] )->fetch(); if (!$dirCheck && $directory !== '/' && strpos($directory, '/') !== false) { $dirName = basename($directory); $parentPath = dirname($directory); if ($parentPath !== '/') { $parentPath .= '/'; } $dirCheck = $db->query( "SELECT path FROM mission_filesystem
             WHERE mission_id = ? AND target_ip = ?
             AND LOWER(name) = LOWER(?)
             AND path LIKE ?
             AND is_directory = 1", [$missionId, $currentIp, $dirName, $parentPath . '%'] )->fetch(); } if (!$dirCheck && $directory !== '/') { echo json_encode([ 'success' => false, 'message' => "cd: $directory: No such directory" ]); exit; } if ($dirCheck && $directory !== '/') { $directory = $dirCheck['path']; } $missionController->updateCurrentDirectory($missionId, $directory); if ($mission->getStatus() == Mission::STATUS_IN_PROGRESS) { $missionController->logCommand($missionId, $currentIp, "cd $directory"); } echo json_encode([ 'success' => true, 'directory' => $directory ]); } elseif ($endpoint === 'connect') { $missionController = new MissionController(); $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; if (!$targetIp) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $activeMission = $missionController->getActiveMission(); if (!$activeMission) { $db = Database::getInstance(); $result = $db->query( "SELECT id FROM missions
             WHERE status = ? AND is_available = 1 AND (target_ip = ? OR secondary_ip = ?)", [Mission::STATUS_NOT_STARTED, $targetIp, $targetIp] ); $mission = $result->fetch(PDO::FETCH_ASSOC); if ($mission) { $result = $missionController->startMission($mission['id']); if ($result['success']) { $activeMission = $missionController->getMission($mission['id']); } else { echo json_encode([ 'success' => false, 'message' => $result['message'] ]); exit; } } else { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.connection_failed_no_mission') ]); exit; } } $progress = $missionController->getMissionProgress($activeMission->getId()); $currentIp = $progress['current_ip']; $validIp = false; if ($targetIp === $activeMission->getTargetIp()) { $validIp = true; } else if ($targetIp === $activeMission->getSecondaryIp()) { $validIp = true; } else { $db = Database::getInstance(); $ipReferences = $db->query( "SELECT COUNT(*) FROM mission_filesystem
             WHERE mission_id = ? AND content LIKE ?", [$activeMission->getId(), "%$targetIp%"] )->fetchColumn(); if ($ipReferences > 0) { $validIp = true; } } if (!$validIp) { $missionController->logCommand($activeMission->getId(), $currentIp, "connect $targetIp", 2); echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.connection_failed_host') ]); exit; } $missionController->logCommand($activeMission->getId(), $currentIp, "connect $targetIp", 3); $missionController->updateCurrentIp($activeMission->getId(), $targetIp); $_SESSION['active_mission_id'] = $activeMission->getId(); if ($activeMission->getId() == 1) { $_SESSION['mission_connected'] = true; } $completionObjective = $activeMission->getCompletionObjective(); if (strpos($completionObjective, 'chain_access:') === 0) { $sessionKey = 'mission_' . $activeMission->getId() . '_accessed_ips'; if (!isset($_SESSION[$sessionKey])) { $_SESSION[$sessionKey] = []; } if (!in_array($targetIp, $_SESSION[$sessionKey])) { $_SESSION[$sessionKey][] = $targetIp; } $validationResult = $missionController->validateObjective($activeMission, 'chain_access', [ 'accessed_ips' => $_SESSION[$sessionKey] ]); if ($validationResult['mission_completed'] ?? false) { echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.connected_to', ['ip' => $targetIp]), 'target_ip' => $targetIp, 'mission_completed' => true, 'objective_message' => $validationResult['message'] ]); exit; } } echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.connected_to', ['ip' => $targetIp]), 'target_ip' => $targetIp ]); } elseif ($endpoint === 'copy_file') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $path = isset($_POST['path']) ? $_POST['path'] : ''; if (!$missionId || !$targetIp || !$path) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); $content = $missionController->getFileContent($missionId, $targetIp, $path); if ($content === null) { $filename = basename($path); echo json_encode([ 'success' => false, 'message' => "cp: cannot stat '$filename': No such file or directory" ]); exit; } if ($mission->getStatus() == Mission::STATUS_IN_PROGRESS) { $logResult = $missionController->logCommand($missionId, $targetIp, "cp $path", 6); $objective = $mission->getCompletionObjective(); if (strpos($objective, 'copy_file:') === 0) { $parts = explode(':', $objective); $traceThreshold = isset($parts[2]) ? (int)$parts[2] : 100; if ($logResult['trace_level'] > $traceThreshold) { $missionController->failMission($missionId); echo json_encode([ 'success' => false, 'mission_failed' => true, 'trace_level' => $logResult['trace_level'], 'trace_exceeded' => true, 'message' => $languageController->translate('api.security_firewall_activated') ]); exit; } } $missionController->addCopiedFile($missionId, $path); $currentTrace = $logResult['trace_level'] ?? 0; } else { $currentTrace = 0; } $db = Database::getInstance(); $gameState = $db->query("SELECT current_year, current_month, current_day FROM game_state WHERE id = 1")->fetch(); $filename = basename($path); $fileSize = strlen($content); $existingFile = $db->query( "SELECT id FROM player_files WHERE filename = ? AND source_mission_id = ? AND source_path = ?", [$filename, $missionId, $path] )->fetch(); if (!$existingFile) { $db->query( "INSERT INTO player_files (filename, content, size, source_mission_id, source_ip, source_path, game_year, game_month, game_day) 
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", [$filename, $content, $fileSize, $missionId, $targetIp, $path, $gameState['current_year'], $gameState['current_month'], $gameState['current_day']] ); } $validationResult = null; if ($mission->getStatus() == Mission::STATUS_IN_PROGRESS) { $objective = $mission->getCompletionObjective(); $objectiveType = explode(':', $objective)[0]; if ($objectiveType === 'find_file' || $objectiveType === 'copy_file' || $objectiveType === 'steal_data' || $objectiveType === 'decrypt_file') { $validationResult = $missionController->validateObjective($mission, $objectiveType, ['file_path' => $path]); } } echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.file_copied_with_name', ['filename' => basename($path)]), 'content' => $content, 'trace_level' => $currentTrace, 'mission_completed' => $validationResult['mission_completed'] ?? false, 'credits_reward' => $validationResult['credits_reward'] ?? null ]); } elseif ($endpoint === 'create_decrypted_file') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $encryptedFile = isset($_POST['encrypted_file']) ? $_POST['encrypted_file'] : ''; $decryptedFile = isset($_POST['decrypted_file']) ? $_POST['decrypted_file'] : ''; $content = isset($_POST['content']) ? $_POST['content'] : ''; if (!$missionId || !$targetIp || !$encryptedFile || !$decryptedFile || !$content) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); if (!$missionController->getFileContent($missionId, $targetIp, $encryptedFile)) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.source_encrypted_file_not_found') ]); exit; } $directory = dirname($decryptedFile); if ($directory === '.') { $directory = '/'; } $db = Database::getInstance(); try { $existingFile = $db->query( "SELECT id FROM mission_filesystem WHERE mission_id = ? AND target_ip = ? AND path = ?", [$missionId, $targetIp, $decryptedFile] )->fetch(); if ($existingFile) { $db->query( "UPDATE mission_filesystem SET content = ? WHERE id = ?", [$content, $existingFile['id']] ); } else { $filename = basename($decryptedFile); $db->query( "INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions, created_at)
                 VALUES (?, ?, ?, ?, 0, ?, 1, '-rw-r--r--', datetime('now'))", [$missionId, $targetIp, $decryptedFile, $filename, $content] ); } $completionObjective = $mission->getCompletionObjective(); $isPartOfObjective = false; if (strpos($completionObjective, 'decrypt_file:') === 0) { $targetFile = substr($completionObjective, 13); if (str_replace('.enc', '', basename($encryptedFile)) === str_replace('.enc', '', $targetFile)) { $isPartOfObjective = true; } } $missionController->getFilesystem($missionId, $targetIp, $directory); echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.file_decrypted_successfully'), 'objective_completed' => false, 'is_part_of_objective' => $isPartOfObjective ]); } catch (\Exception $e) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.database_error', ['error' => $e->getMessage()]) ]); } } elseif ($endpoint === 'get_file_content') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $path = isset($_POST['path']) ? $_POST['path'] : ''; if (!$missionId || !$targetIp || !$path) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); $content = $missionController->getFileContent($missionId, $targetIp, $path); if ($content === null) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.file_not_found_directory') ]); exit; } if (strpos($path, 'system.log') !== false) { $logs = $missionController->getMissionLogs($missionId, $targetIp); if (!empty($logs)) { $content .= "\n\n# Command Logs #\n"; foreach ($logs as $log) { $timestamp = date('M d H:i:s', strtotime($log['timestamp'])); $content .= "$timestamp {$targetIp} user: {$log['command']}\n"; } } } if ($mission->getStatus() == Mission::STATUS_IN_PROGRESS) { $missionController->logCommand($missionId, $targetIp, "cat $path"); } $completionObjective = $mission->getCompletionObjective(); if (strpos($completionObjective, 'find_file:') === 0) { $targetFile = substr($completionObjective, 10); if (basename($path) === $targetFile) { if ($missionId == 1) { echo json_encode([ 'success' => true, 'content' => $content, 'is_objective' => true, 'message' => $languageController->translate('vds.file_is_objective', ['filename' => basename($path)]) ]); } else { echo json_encode([ 'success' => true, 'content' => $content ]); } exit; } } echo json_encode([ 'success' => true, 'content' => $content ]); } elseif ($endpoint === 'rm_file') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $path = isset($_POST['path']) ? $_POST['path'] : ''; if (!$missionId || !$targetIp || !$path) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); $result = $missionController->deleteFile($missionId, $targetIp, $path); if ($result) { if ($mission->getStatus() == Mission::STATUS_IN_PROGRESS) { $missionController->logCommand($missionId, $targetIp, "rm $path"); } $completionObjective = $mission->getCompletionObjective(); $objectiveType = explode(':', $completionObjective)[0]; if ($objectiveType === 'delete_file' || $objectiveType === 'delete_multiple') { $validationResult = $missionController->validateObjective($mission, $objectiveType, ['file_path' => $path]); echo json_encode([ 'success' => $validationResult['success'], 'message' => $validationResult['message'], 'is_objective' => $validationResult['objective_completed'] ?? false, 'mission_completed' => $validationResult['mission_completed'] ?? false, 'credits_reward' => $validationResult['credits_reward'] ?? null ]); } else { echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.file_deleted_successfully', ['path' => basename($path)]) ]); } } else { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.error_deleting_file') ]); } } elseif ($endpoint === 'corrupt_file') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $path = isset($_POST['path']) ? $_POST['path'] : ''; if (!$missionId || !$targetIp || !$path) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); $db = Database::getInstance(); $file = $db->query( "SELECT * FROM mission_filesystem WHERE mission_id = ? AND target_ip = ? AND (path = ? OR path = ?) AND is_directory = 0", [$missionId, $targetIp, $path, strtolower($path)] )->fetch(); if (!$file) { echo json_encode([ 'success' => false, 'message' => "corrupt: cannot stat '" . basename($path) . "': No such file or directory" ]); exit; } $corruptedContent = "CORRUPTED DATA - FILE INTEGRITY COMPROMISED\n"; $corruptedContent .= str_repeat("X", 100) . "\n"; $corruptedContent .= "CHECKSUM MISMATCH - EVIDENCE INVALID\n"; $db->query( "UPDATE mission_filesystem SET content = ? WHERE id = ?", [$corruptedContent, $file['id']] ); if ($mission->getStatus() == Mission::STATUS_IN_PROGRESS) { $missionController->logCommand($missionId, $targetIp, "corrupt $path"); } $completionObjective = $mission->getCompletionObjective(); $objectiveType = explode(':', $completionObjective)[0]; $validationResult = null; if ($objectiveType === 'corrupt_logs') { $validationResult = $missionController->validateObjective($mission, $objectiveType, ['file_path' => $path]); } echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.file_corrupted_successfully', ['filename' => basename($path)]), 'mission_completed' => $validationResult['mission_completed'] ?? false, 'credits_reward' => $validationResult['credits_reward'] ?? null ]); } elseif ($endpoint === 'validate_objective') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $actionType = isset($_POST['action_type']) ? $_POST['action_type'] : ''; $actionData = isset($_POST['action_data']) ? json_decode($_POST['action_data'], true) : []; if (!$missionId || !$actionType) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); $validationResult = $missionController->validateObjective($mission, $actionType, $actionData); echo json_encode($validationResult); } elseif ($endpoint === 'disconnect') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; if (!$missionId || !$targetIp) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); $db = Database::getInstance(); $logFiles = $db->query( "SELECT COUNT(*) FROM mission_filesystem
         WHERE mission_id = ? AND target_ip = ? AND path LIKE '%.log%'", [$missionId, $targetIp] )->fetchColumn(); if ($logFiles > 0) { $attentionIncrease = mt_rand(3, 6); $currentAttention = $db->query("SELECT attention_level FROM game_state WHERE id = 1")->fetchColumn(); $newAttention = min(100, $currentAttention + $attentionIncrease); $db->query( "UPDATE game_state SET attention_level = ? WHERE id = 1", [$newAttention] ); echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.disconnected_system'), 'attention_increased' => true, 'attention_change' => $attentionIncrease, 'old_attention' => $currentAttention, 'new_attention' => $newAttention ]); } else { echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.disconnected_system'), 'attention_increased' => false ]); } } elseif ($endpoint === 'modify_file') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $path = isset($_POST['path']) ? $_POST['path'] : ''; $password = isset($_POST['password']) ? $_POST['password'] : null; if (!$missionId || !$targetIp || !$path) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS && $mission->getStatus() != Mission::STATUS_COMPLETED) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_accessible') ]); exit; } $missionController = new MissionController(); $fileContent = $missionController->getFileContent($missionId, $targetIp, $path); if ($fileContent === null) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.file_not_found_access_denied') ]); exit; } if ($mission->getStatus() == Mission::STATUS_IN_PROGRESS) { $commandLog = "modify $path"; if ($password) { $commandLog .= " " . $password; } $missionController->logCommand($missionId, $targetIp, $commandLog); } $completionObjective = $mission->getCompletionObjective(); $objectiveType = explode(':', $completionObjective)[0]; if ($objectiveType === 'plant_backdoor') { $validationResult = $missionController->validateObjective($mission, 'plant_backdoor', [ 'file_path' => $path, 'password' => $password ]); echo json_encode([ 'success' => $validationResult['success'], 'message' => $validationResult['message'], 'is_objective' => $validationResult['objective_completed'] ?? false, 'mission_completed' => $validationResult['mission_completed'] ?? false, 'credits_reward' => $validationResult['credits_reward'] ?? null ]); } elseif ($objectiveType === 'modify_file') { $validationResult = $missionController->validateObjective($mission, 'modify_file', [ 'file_path' => $path, 'password' => $password ]); echo json_encode([ 'success' => $validationResult['success'], 'message' => $validationResult['message'], 'is_objective' => $validationResult['objective_completed'] ?? false, 'mission_completed' => $validationResult['mission_completed'] ?? false, 'credits_reward' => $validationResult['credits_reward'] ?? null ]); } else { echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.file_modified_successfully') ]); } } elseif ($endpoint === 'modify_content') { try { $missionId = $_POST['mission_id'] ?? null; $targetIp = $_POST['target_ip'] ?? null; $path = $_POST['path'] ?? null; $oldText = $_POST['old_text'] ?? null; $newText = $_POST['new_text'] ?? null; if (!$missionId || !$targetIp || !$path || $oldText === null || $newText === null) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $db = Database::getInstance(); $missionController = new MissionController(); $result = $db->query( "SELECT id, path, content FROM mission_filesystem
             WHERE mission_id = ? AND target_ip = ? AND LOWER(path) LIKE LOWER(?) AND is_directory = 0", [$missionId, $targetIp, '%' . basename($path)] ); $file = $result->fetch(PDO::FETCH_ASSOC); if (!$file) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.file_not_found') . ': ' . basename($path) ]); exit; } $fileContent = $file['content']; $actualPath = $file['path']; $fileId = $file['id']; if (strpos($fileContent, $oldText) === false) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.text_not_found_in_file', ['text' => $oldText]) ]); exit; } $newContent = str_replace($oldText, $newText, $fileContent); $db->query( "UPDATE mission_filesystem SET content = ? WHERE id = ?", [$newContent, $fileId] ); echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.file_content_modified', ['filename' => basename($actualPath)]), 'filepath' => $actualPath ]); $mission = $missionController->getMission($missionId); if ($mission) { $objective = $mission->getCompletionObjective(); $objectiveType = explode(':', $objective)[0]; if ($objectiveType === 'modify_content') { $missionController->validateObjective($mission, 'modify_content', [ 'file' => $actualPath, 'old_text' => $oldText, 'new_text' => $newText ]); } } } catch (Exception $e) { echo json_encode([ 'success' => false, 'message' => 'Error: ' . $e->getMessage() ]); } } elseif ($endpoint === 'ping_target') { checkActiveMission(); $missionId = isset($_POST['mission_id']) ? (int)$_POST['mission_id'] : $_SESSION['active_mission_id']; $targetIp = isset($_POST['target_ip']) ? $_POST['target_ip'] : ''; $currentIp = isset($_POST['current_ip']) ? $_POST['current_ip'] : ''; if (!$missionId || !$targetIp) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.missing_required_parameters') ]); exit; } $mission = validateMission($missionId); if ($mission->getStatus() != Mission::STATUS_IN_PROGRESS) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.mission_not_in_progress') ]); exit; } $missionController = new MissionController(); $missionController->logCommand($missionId, $currentIp, "ping $targetIp"); $completionObjective = $mission->getCompletionObjective(); $objectiveType = explode(':', $completionObjective)[0]; if ($objectiveType !== 'ping_targets') { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.ping_not_required') ]); exit; } $objectiveParts = explode(':', $completionObjective); if (count($objectiveParts) < 2) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.invalid_objective_config') ]); exit; } $requiredTargets = array_map('trim', explode(',', $objectiveParts[1])); if (!in_array($targetIp, $requiredTargets)) { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.target_not_in_mission') ]); exit; } $db = Database::getInstance(); $db->query( "INSERT OR IGNORE INTO mission_ping_targets (mission_id, target_ip) VALUES (?, ?)", [$missionId, $targetIp] ); $result = $db->query( "SELECT COUNT(DISTINCT target_ip) as count FROM mission_ping_targets WHERE mission_id = ?", [$missionId] )->fetch(); $currentPingedCount = $result['count']; $pingedResult = $db->query( "SELECT target_ip FROM mission_ping_targets WHERE mission_id = ?", [$missionId] )->fetchAll(PDO::FETCH_COLUMN); $allPinged = true; foreach ($requiredTargets as $requiredIp) { if (!in_array($requiredIp, $pingedResult)) { $allPinged = false; break; } } $missionComplete = false; $creditsReward = null; if ($allPinged) { $validationResult = $missionController->validateObjective($mission, 'ping_targets', [ 'pinged_targets' => $pingedResult ]); $missionComplete = $validationResult['mission_completed'] ?? false; $creditsReward = $validationResult['credits_reward'] ?? null; } echo json_encode([ 'success' => true, 'message' => $languageController->translate('api.ping_successful'), 'pinged_count' => $currentPingedCount, 'total_required' => count($requiredTargets), 'mission_complete' => $missionComplete, 'credits_reward' => $creditsReward ]); } else { echo json_encode([ 'success' => false, 'message' => $languageController->translate('api.invalid_endpoint') ]); } ?>
